<?php
declare(strict_types=1);

require __DIR__ . '/../app/bootstrap.php';

session_start();

use App\Core\Router;

$router = new Router();

// Public routes
$router->get('/', 'AuthController@showLogin');
$router->get('/login', 'AuthController@showLogin');
$router->post('/login', 'AuthController@login');

$router->get('/register-company', 'AuthController@showCompanyRegister');
$router->post('/register-company', 'AuthController@registerCompany');

$router->post('/logout', 'AuthController@logout');

// Protected routes
$router->get('/dashboard', 'DashboardController@index', true);

// Users (admin only)
$router->get('/users', 'UserController@index', true);
$router->get('/users/create', 'UserController@create', true);
$router->post('/users', 'UserController@store', true);
$router->post('/users/toggle', 'UserController@toggleStatus', true);

// Visitors
$router->get('/visitors', 'VisitorController@index', true);
$router->get('/visitors/create', 'VisitorController@create', true);
$router->post('/visitors', 'VisitorController@store', true);
$router->get('/visitors/edit', 'VisitorController@edit', true);
$router->post('/visitors/update', 'VisitorController@update', true);
$router->post('/visitors/checkout', 'VisitorController@checkout', true);
$router->get('/visitors/print', 'VisitorController@printPass', true);
$router->get('/visitors/export', 'VisitorController@exportCsv', true);

$router->dispatch();
