<?php
/**
 * Migration: Add photo_path column to visitors table
 * Run this file once to update your database
 */

require __DIR__ . '/../app/bootstrap.php';

use App\Core\DB;

try {
    $pdo = DB::pdo();
    
    // Check if column already exists
    $stmt = $pdo->prepare("SHOW COLUMNS FROM visitors WHERE Field = 'photo_path'");
    $stmt->execute();
    
    if ($stmt->rowCount() === 0) {
        // Add the photo_path column
        $sql = "ALTER TABLE visitors ADD COLUMN photo_path VARCHAR(255) NULL AFTER status";
        $pdo->exec($sql);
        echo "✓ Column 'photo_path' added successfully to visitors table\n";
    } else {
        echo "✓ Column 'photo_path' already exists\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
    exit(1);
}
