<?php use App\Core\Utils; use App\Core\QRCode; ?>
<style>
@media print {
  nav, footer, .no-print { display:none !important; }
  body { background: #fff !important; }
}
.pass-card { max-width: 520px; margin: 0 auto; }
.photo-section { text-align: center; margin-bottom: 15px; }
.photo-section img { max-width: 100px; height: 100px; border-radius: 4px; border: 1px solid #dee2e6; object-fit: cover; }
.qr-code { text-align: center; padding: 10px; background: #f8f9fa; border-radius: 4px; }
.qr-code img { max-width: 120px; }
</style>

<div class="no-print d-flex justify-content-between align-items-center mb-3">
  <a class="btn btn-link" href="<?= Utils::e($baseUrl) ?>/visitors"><i class="bi bi-arrow-left"></i> Back to Visitors</a>
  <button class="btn btn-primary" onclick="window.print()"><i class="bi bi-printer"></i> Print</button>
</div>

<div class="card border-0 shadow-sm pass-card">
  <div class="card-body p-4">
    <div class="d-flex justify-content-between align-items-start mb-3">
      <div>
        <div class="text-muted small">Visitor Pass</div>
        <h4 class="mb-0"><?= Utils::e($v['visitor_name'] ?? '') ?></h4>
        <div class="text-muted"><?= Utils::e($v['visitor_company'] ?? '') ?></div>
      </div>
      <div class="text-end">
        <div class="badge bg-primary fs-6">#<?= (int)($v['id'] ?? 0) ?></div>
        <div class="text-muted small mt-2">Status: <?= strtoupper(Utils::e($v['status'] ?? '')) ?></div>
      </div>
    </div>

    <!-- Photo Section -->
    <?php if (!empty($v['photo_path'])): ?>
      <div class="photo-section">
        <img src="<?= Utils::e($baseUrl) ?>/<?= Utils::e($v['photo_path']) ?>" alt="Visitor Photo">
      </div>
    <?php else: ?>
      <div class="photo-section text-muted small py-3">
        <i class="bi bi-image" style="font-size: 40px;"></i><br>No Photo
      </div>
    <?php endif; ?>

    <!-- QR Code Section -->
    <div class="qr-code mb-3">
      <img src="<?= QRCode::generateURL((int)($v['id'] ?? 0), (int)($v['company_id'] ?? 0)) ?>" alt="QR Code">
      <div class="text-muted small mt-2">Scan for verification</div>
    </div>

    <div class="row g-2 small">
      <div class="col-6"><div class="text-muted">Phone</div><div><?= Utils::e($v['visitor_phone'] ?? '') ?></div></div>
      <div class="col-6"><div class="text-muted">Email</div><div><?= Utils::e($v['visitor_email'] ?? '') ?></div></div>

      <div class="col-6"><div class="text-muted">Purpose</div><div><?= Utils::e($v['purpose'] ?? '') ?></div></div>
      <div class="col-6"><div class="text-muted">Host</div><div><?= Utils::e($v['host_name'] ?? '') ?></div></div>

      <div class="col-6"><div class="text-muted">Check-in</div><div><?= Utils::e($v['check_in_at'] ?? '') ?></div></div>
      <div class="col-6"><div class="text-muted">Check-out</div><div><?= Utils::e($v['check_out_at'] ?? '-') ?></div></div>

      <div class="col-6"><div class="text-muted">ID</div><div><?= Utils::e(($v['id_type'] ?? '').' '.($v['id_number'] ?? '')) ?></div></div>
      <div class="col-6"><div class="text-muted">Vehicle</div><div><?= Utils::e($v['vehicle_no'] ?? '') ?></div></div>
    </div>

    <hr>
    <div class="text-muted small">
      Please return this pass at exit. This is a computer-generated pass.
    </div>
  </div>
</div>
