<?php use App\Core\Utils; ?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <div>
    <h4 class="mb-0">Visitors</h4>
    <div class="text-muted">Manage visitor entries (add, edit, checkout, print, export).</div>
  </div>
  <div class="d-flex gap-2">
    <a href="<?= Utils::e($baseUrl) ?>/visitors/export?status=<?= Utils::e($filters['status'] ?? '') ?>&q=<?= urlencode($filters['q'] ?? '') ?>" class="btn btn-outline-secondary">
      <i class="bi bi-download"></i> Export CSV
    </a>
    <a href="<?= Utils::e($baseUrl) ?>/visitors/create" class="btn btn-success">
      <i class="bi bi-plus-lg"></i> New Visitor
    </a>
  </div>
</div>

<div class="card border-0 shadow-sm mb-3">
  <div class="card-body">
    <form class="row g-2" method="get" action="<?= Utils::e($baseUrl) ?>/visitors">
      <div class="col-md-6">
        <input class="form-control" name="q" placeholder="Search by name/phone/purpose/host..." value="<?= Utils::e($filters['q'] ?? '') ?>">
      </div>
      <div class="col-md-3">
        <select class="form-select" name="status">
          <option value="">All status</option>
          <option value="in" <?= ($filters['status'] ?? '')==='in'?'selected':'' ?>>IN</option>
          <option value="out" <?= ($filters['status'] ?? '')==='out'?'selected':'' ?>>OUT</option>
        </select>
      </div>
      <div class="col-md-3 d-grid">
        <button class="btn btn-primary"><i class="bi bi-search"></i> Filter</button>
      </div>
    </form>
  </div>
</div>

<div class="card border-0 shadow-sm">
  <div class="card-body">
    <div class="table-responsive">
      <table class="table align-middle">
        <thead>
          <tr>
            <th>ID</th><th>Visitor</th><th>Purpose</th><th>Host</th><th>Check-in</th><th>Status</th><th class="text-end">Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach (($visitors ?? []) as $v): ?>
            <tr>
              <td><?= (int)$v['id'] ?></td>
              <td>
                <div class="fw-semibold"><?= Utils::e($v['visitor_name']) ?></div>
                <div class="text-muted small"><?= Utils::e($v['visitor_phone'] ?? '') ?> <?= $v['visitor_email'] ? '· '.Utils::e($v['visitor_email']) : '' ?></div>
              </td>
              <td><?= Utils::e($v['purpose']) ?></td>
              <td><?= Utils::e($v['host_name'] ?? '') ?></td>
              <td><?= Utils::e($v['check_in_at']) ?></td>
              <td>
                <span class="badge bg-<?= $v['status']==='in'?'success':'secondary' ?>"><?= strtoupper(Utils::e($v['status'])) ?></span>
              </td>
              <td class="text-end">
                <a class="btn btn-outline-secondary btn-sm" href="<?= Utils::e($baseUrl) ?>/visitors/print?id=<?= (int)$v['id'] ?>"><i class="bi bi-printer"></i></a>
                <a class="btn btn-outline-primary btn-sm" href="<?= Utils::e($baseUrl) ?>/visitors/edit?id=<?= (int)$v['id'] ?>"><i class="bi bi-pencil"></i></a>
                <?php if ($v['status']==='in'): ?>
                  <form method="post" action="<?= Utils::e($baseUrl) ?>/visitors/checkout" class="d-inline">
                    <input type="hidden" name="csrf_token" value="<?= Utils::e($csrf) ?>">
                    <input type="hidden" name="id" value="<?= (int)$v['id'] ?>">
                    <button class="btn btn-outline-success btn-sm" title="Checkout"><i class="bi bi-box-arrow-right"></i></button>
                  </form>
                <?php endif; ?>
              </td>
            </tr>
          <?php endforeach; ?>
          <?php if (empty($visitors)): ?>
            <tr><td colspan="7" class="text-muted">No visitors found.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
