<?php use App\Core\Utils; ?>
<div class="row justify-content-center">
  <div class="col-lg-9">
    <div class="card border-0 shadow-sm">
      <div class="card-body p-4">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <h4 class="mb-0">Edit Visitor</h4>
          <a class="btn btn-link" href="<?= Utils::e($baseUrl) ?>/visitors">Back</a>
        </div>
        <?php if (!empty($error)): ?>
          <div class="alert alert-danger"><?= Utils::e($error) ?></div>
        <?php endif; ?>
        <form method="post" action="<?= Utils::e($baseUrl) ?>/visitors/update">
          <input type="hidden" name="csrf_token" value="<?= Utils::e($csrf) ?>">
          <input type="hidden" name="id" value="<?= (int)$v['id'] ?>">
          <?php App\Core\View::partial('visitors/_form_fields', ['v' => $v]); ?>
          <div class="mt-3 d-flex gap-2">
            <button class="btn btn-primary"><i class="bi bi-save2"></i> Save</button>
            <a class="btn btn-outline-secondary" href="<?= Utils::e($baseUrl) ?>/visitors/print?id=<?= (int)$v['id'] ?>"><i class="bi bi-printer"></i> Print Pass</a>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
