<?php use App\Core\Utils; ?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <div>
    <h4 class="mb-0">Users</h4>
    <div class="text-muted">Create staff users for your company.</div>
  </div>
  <a href="<?= Utils::e($baseUrl) ?>/users/create" class="btn btn-success">
    <i class="bi bi-person-plus"></i> Add User
  </a>
</div>

<div class="card border-0 shadow-sm">
  <div class="card-body">
    <div class="table-responsive">
      <table class="table align-middle">
        <thead>
          <tr>
            <th>Name</th><th>Email</th><th>Role</th><th>Status</th><th>Created</th><th class="text-end">Action</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($users as $x): ?>
            <tr>
              <td><?= Utils::e($x['name']) ?></td>
              <td><?= Utils::e($x['email']) ?></td>
              <td><span class="badge bg-info"><?= Utils::e($x['role']) ?></span></td>
              <td><span class="badge bg-<?= $x['status']==='active'?'success':'secondary' ?>"><?= Utils::e($x['status']) ?></span></td>
              <td><?= Utils::e($x['created_at']) ?></td>
              <td class="text-end">
                <form method="post" action="<?= Utils::e($baseUrl) ?>/users/toggle" class="d-inline">
                  <input type="hidden" name="csrf_token" value="<?= Utils::e($csrf) ?>">
                  <input type="hidden" name="id" value="<?= (int)$x['id'] ?>">
                  <button class="btn btn-outline-primary btn-sm">Toggle</button>
                </form>
              </td>
            </tr>
          <?php endforeach; ?>
          <?php if (empty($users)): ?>
            <tr><td colspan="6" class="text-muted">No users yet.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
