<?php use App\Core\Utils; ?>
<div class="row justify-content-center">
  <div class="col-lg-6">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <h4 class="mb-1">Add User</h4>
        <p class="text-muted">Create a staff user or another admin.</p>
        <?php if (!empty($error)): ?>
          <div class="alert alert-danger"><?= Utils::e($error) ?></div>
        <?php endif; ?>
        <form method="post" action="<?= Utils::e($baseUrl) ?>/users">
          <input type="hidden" name="csrf_token" value="<?= Utils::e($csrf) ?>">
          <div class="mb-3">
            <label class="form-label">Name</label>
            <input class="form-control" name="name" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Email</label>
            <input class="form-control" name="email" type="email" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Password (8+ chars)</label>
            <input class="form-control" name="password" type="password" minlength="8" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Role</label>
            <select class="form-select" name="role">
              <option value="staff_user" selected>Staff User</option>
              <option value="company_admin">Company Admin</option>
            </select>
          </div>
          <button class="btn btn-primary">Create</button>
          <a class="btn btn-link" href="<?= Utils::e($baseUrl) ?>/users">Back</a>
        </form>
      </div>
    </div>
  </div>
</div>
