<?php
use App\Core\Utils;
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= Utils::e($appName) ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
  <link href="<?= Utils::e($baseUrl) ?>/assets/app.css" rel="stylesheet">
</head>
<body class="bg-light">
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
  <div class="container">
    <a class="navbar-brand fw-semibold" href="<?= Utils::e($baseUrl) ?>/dashboard">
      <i class="bi bi-building-check"></i> <?= Utils::e($appName) ?>
    </a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nav">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="nav">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <?php if ($currentUser): ?>
          <li class="nav-item"><a class="nav-link" href="<?= Utils::e($baseUrl) ?>/dashboard">Dashboard</a></li>
          <li class="nav-item"><a class="nav-link" href="<?= Utils::e($baseUrl) ?>/visitors">Visitors</a></li>
          <?php if (($currentUser['role'] ?? '') === 'company_admin'): ?>
            <li class="nav-item"><a class="nav-link" href="<?= Utils::e($baseUrl) ?>/users">Users</a></li>
          <?php endif; ?>
        <?php endif; ?>
      </ul>
      <div class="d-flex gap-2 align-items-center">
        <?php if ($currentUser): ?>
          <span class="text-white-50 small d-none d-md-inline">
            <?= Utils::e($currentUser['name'] ?? '') ?> (<?= Utils::e($currentUser['role'] ?? '') ?>)
          </span>
          <form method="post" action="<?= Utils::e($baseUrl) ?>/logout" class="m-0">
            <input type="hidden" name="csrf_token" value="<?= Utils::e($csrf) ?>">
            <button class="btn btn-outline-light btn-sm"><i class="bi bi-box-arrow-right"></i> Logout</button>
          </form>
        <?php else: ?>
          <a class="btn btn-outline-light btn-sm" href="<?= Utils::e($baseUrl) ?>/login">Login</a>
        <?php endif; ?>
      </div>
    </div>
  </div>
</nav>

<main class="container my-4">
  <?php App\Core\View::partial($viewPath, get_defined_vars()); ?>
</main>

<footer class="py-4">
  <div class="container text-center text-muted small">
    © <?= date('Y') ?> VMS Nuromint · Built for modern visitor workflows
  </div>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="<?= Utils::e($baseUrl) ?>/assets/app.js"></script>
</body>
</html>
