<?php use App\Core\Utils; ?>
<div class="row justify-content-center">
  <div class="col-lg-7">
    <div class="card border-0 shadow-sm">
      <div class="card-body p-4">
        <h4 class="mb-1">Register Your Company</h4>
        <p class="text-muted mb-3">Create your company profile and admin login.</p>
        <?php if (!empty($error)): ?>
          <div class="alert alert-danger"><?= Utils::e($error) ?></div>
        <?php endif; ?>
        <form method="post" action="<?= Utils::e($baseUrl) ?>/register-company" class="row g-3">
          <input type="hidden" name="csrf_token" value="<?= Utils::e($csrf) ?>">
          <div class="col-md-6">
            <label class="form-label">Company Name *</label>
            <input class="form-control" name="company_name" required>
          </div>
          <div class="col-md-6">
            <label class="form-label">Company Email *</label>
            <input class="form-control" name="company_email" type="email" required>
          </div>
          <div class="col-md-6">
            <label class="form-label">Company Phone</label>
            <input class="form-control" name="company_phone">
          </div>
          <div class="col-md-6">
            <label class="form-label">Company Address</label>
            <input class="form-control" name="company_address">
          </div>

          <hr class="my-2">

          <div class="col-md-6">
            <label class="form-label">Admin Name *</label>
            <input class="form-control" name="admin_name" required>
          </div>
          <div class="col-md-6">
            <label class="form-label">Admin Email *</label>
            <input class="form-control" name="admin_email" type="email" required>
          </div>
          <div class="col-md-6">
            <label class="form-label">Admin Password * (8+ chars)</label>
            <input class="form-control" name="admin_password" type="password" minlength="8" required>
          </div>
          <div class="col-12">
            <button class="btn btn-primary">Create Company</button>
            <a class="btn btn-link" href="<?= Utils::e($baseUrl) ?>/login">Back to login</a>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
