<?php
namespace App\Core;

class App {
  public static array $config = [];

  public static function init(array $config): void {
    self::$config = $config;

    // Set default timezone (adjust if needed)
    date_default_timezone_set('Asia/Kolkata');

    // Init DB
    DB::init(
      $config['DB_HOST'],
      $config['DB_NAME'],
      $config['DB_USER'],
      $config['DB_PASS']
    );
  }

  public static function config(string $key, $default=null) {
    return self::$config[$key] ?? $default;
  }
}
