<?php
namespace App\Controllers;

use App\Core\View;
use App\Core\Auth;
use App\Core\CSRF;
use App\Core\Response;
use App\Models\User;

class UserController {
  public function index(): void {
    Auth::requireAdmin();
    $u = Auth::user();
    $users = User::listByCompany((int)$u['company_id']);
    View::render('users/index', ['users'=>$users]);
  }

  public function create(): void {
    Auth::requireAdmin();
    View::render('users/create', ['error'=>null]);
  }

  public function store(): void {
    Auth::requireAdmin();
    CSRF::verify();
    $u = Auth::user();

    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $pass = (string)($_POST['password'] ?? '');
    $role = ($_POST['role'] ?? 'staff_user') === 'company_admin' ? 'company_admin' : 'staff_user';

    if ($name==='' || $email==='' || strlen($pass) < 8) {
      View::render('users/create', ['error'=>'All fields required. Password must be 8+ chars.']);
      return;
    }

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
      View::render('users/create', ['error'=>'Invalid email format.']);
      return;
    }

    $hash = password_hash($pass, PASSWORD_DEFAULT);
    User::create([
      'company_id'=>(int)$u['company_id'],
      'name'=>$name,
      'email'=>$email,
      'password_hash'=>$hash,
      'role'=>$role,
    ]);

    Response::redirect('/users');
  }

  public function toggleStatus(): void {
    Auth::requireAdmin();
    CSRF::verify();
    $u = Auth::user();
    $id = (int)($_POST['id'] ?? 0);
    if ($id > 0) {
      User::toggleStatus((int)$u['company_id'], $id);
    }
    Response::redirect('/users');
  }
}
